<?php
$servername = "localhost";
$username = "bpoosspc_certi";
$password = "Admin@pass123";
$dbname = "bpoosspc_certi";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$sql = "SELECT id, name, register_number, department, domain, from_date, to_date, date_generated FROM internship_certificates ORDER BY date_generated DESC";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stored Internship Certificates</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 900px;
            margin: auto;
            background: white;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 5px;
        }
        h2 {
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: left;
        }
        th {
            background: #007bff;
            color: white;
        }
        .view-button {
            padding: 5px 10px;
            background: #28a745;
            color: white;
            border: none;
            text-decoration: none;
            border-radius: 4px;
        }
        .view-button:hover {
            background: #218838;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Stored Internship Certificates</h2>
        <table>
            <tr>
                <th>Name</th>
                <th>Register Number</th>
                <th>Department</th>
                <th>Internship Domain</th>
                <th>Internship Period</th>
                <th>Date Generated</th>
                <th>Action</th>
            </tr>
            <?php while ($row = $result->fetch_assoc()) { ?>
                <tr>
                    <td><?php echo htmlspecialchars($row['name']); ?></td>
                    <td><?php echo htmlspecialchars($row['register_number']); ?></td>
                    <td><?php echo htmlspecialchars($row['department']); ?></td>
                    <td><?php echo htmlspecialchars($row['domain']); ?></td>
                    <td><?php echo htmlspecialchars($row['from_date'] . ' to ' . $row['to_date']); ?></td>
                    <td><?php echo htmlspecialchars($row['date_generated']); ?></td>
                    <td><a href="certificate.php?name=<?php echo urlencode($row['name']); ?>&register_number=<?php echo urlencode($row['register_number']); ?>&department=<?php echo urlencode($row['department']); ?>&domain=<?php echo urlencode($row['domain']); ?>&from_date=<?php echo urlencode($row['from_date']); ?>&to_date=<?php echo urlencode($row['to_date']); ?>&date=<?php echo urlencode($row['date_generated']); ?>" class="view-button" target="_blank">View Certificate</a></td>
                </tr>
            <?php } ?>
        </table>
    </div>
</body>
</html>

<?php $conn->close(); ?>
